<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile_user}}`.
 */
class m260206_180139_create_profile_user_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'email' => $this->string(100)->notNull()->unique(),
            'password_hash' => $this->string(255)->notNull(),
            'auth_key' => $this->string(32)->notNull(),
            'full_name' => $this->string(150)->notNull(),
            'phone' => $this->string(20)->notNull(),
            'passport' => $this->string(50)->notNull(),
            'address' => $this->text()->notNull(),
            'role' => $this->string(20)->notNull()->defaultValue('user'),
            'status' => $this->smallInteger()->notNull()->defaultValue(10),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], $tableOptions);

        // Добавляем администратора по умолчанию
        $this->insert('{{%user}}', [
            'email' => 'admintour@mail.ru',
            'password_hash' => Yii::$app->security->generatePasswordHash('admintour'),
            'auth_key' => Yii::$app->security->generateRandomString(),
            'full_name' => 'Администратор Системы',
            'phone' => '+7(999)999-99-99',
            'passport' => '0000 000000',
            'address' => 'Административный адрес',
            'role' => 'admin',
            'status' => 10,
            'created_at' => time(),
            'updated_at' => time(),
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%profile_user}}');
    }
}
