<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile_tour}}`.
 */
class m260206_180208_create_profile_tour_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%tour}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(200)->notNull(),
            'slug' => $this->string(200)->notNull()->unique(),
            'description' => $this->text()->notNull(),
            'short_description' => $this->string(500),
            'price' => $this->decimal(10, 2)->notNull(),
            'duration_days' => $this->integer()->defaultValue(1),
            'max_participants' => $this->integer()->defaultValue(20),
            'program' => $this->text(),
            'image' => $this->string(255),
            'gallery' => $this->text(), // JSON массив изображений
            'is_active' => $this->boolean()->defaultValue(true),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], $tableOptions);

        // Добавляем тестовые туры
        $tours = [
            [
                'name' => 'Зюраткуль',
                'description' => 'Тур на озеро Зюраткуль - одно из самых высокогорных озер Урала. Включает прогулку по экотропе, посещение национального парка и обед с видом на озеро.',
                'price' => 3500.00,
                'duration_days' => 1,
            ],
            [
                'name' => 'Таганай',
                'description' => 'Тур в национальный парк Таганай. Восхождение на Откликной гребень, посещение Долины сказок и Белого ключа.',
                'price' => 4200.00,
                'duration_days' => 2,
            ],
            [
                'name' => 'Тургояк',
                'description' => 'Тур на озеро Тургояк - уральский Байкал. Отдых на пляже, прогулка на катере и посещение острова Веры.',
                'price' => 3800.00,
                'duration_days' => 1,
            ],
            [
                'name' => 'Аракульский шихан',
                'description' => 'Восхождение на Аракульский шихан - гранитный скальный массив с потрясающими видами на озеро Аракуль.',
                'price' => 3200.00,
                'duration_days' => 1,
            ],
            [
                'name' => 'Уральский Марс',
                'description' => 'Тур на Уральский Марс - карьер с красной глиной, напоминающий марсианский пейзаж. Фотосессия и прогулка по уникальному ландшафту.',
                'price' => 4000.00,
                'duration_days' => 1,
            ],
        ];

        foreach ($tours as $tour) {
            $this->insert('{{%tour}}', [
                'name' => $tour['name'],
                'slug' => Yii::$app->security->generateRandomString(8),
                'description' => $tour['description'],
                'short_description' => mb_substr($tour['description'], 0, 150) . '...',
                'price' => $tour['price'],
                'duration_days' => $tour['duration_days'],
                'image' => 'tour' . rand(1, 5) . '.jpg',
                'is_active' => true,
                'created_at' => time(),
                'updated_at' => time(),
            ]);
        }
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%profile_tour}}');
    }
}
