<?php

namespace app\models;

use Yii;
use yii\base\Model;

/**
 * LoginForm - форма входа в систему
 */
class LoginForm extends Model
{
    public $email;
    public $password;
    public $rememberMe = true;

    private $_user = false;

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            // Обязательные поля
            [['email', 'password'], 'required'],
            
            // Валидация email
            ['email', 'email'],
            
            // Запомнить меня
            ['rememberMe', 'boolean'],
            
            // Валидация пароля
            ['password', 'validatePassword'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'email' => 'Email',
            'password' => 'Пароль',
            'rememberMe' => 'Запомнить меня',
        ];
    }

    /**
     * Валидация пароля
     */
    public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();

            if (!$user) {
                $this->addError($attribute, 'Пользователь с таким email не найден.');
            } elseif (!$user->validatePassword($this->password)) {
                $this->addError($attribute, 'Неверный пароль.');
            }
        }
    }

    /**
     * Авторизация пользователя
     */
    public function login()
    {
        if ($this->validate()) {
            $duration = $this->rememberMe ? 3600 * 24 * 30 : 0; // 30 дней или сессия
            return Yii::$app->user->login($this->getUser(), $duration);
        }
        return false;
    }

    /**
     * Получение пользователя по email
     */
    public function getUser()
    {
        if ($this->_user === false) {
            $this->_user = User::findByEmail($this->email);
        }

        return $this->_user;
    }
}