<?php

namespace app\models;

use yii\db\ActiveRecord;

class Review extends ActiveRecord
{
    public static function tableName()
    {
        return 'review';
    }

    public function rules()
    {
        return [
            [['user_id', 'tour_id', 'rating', 'comment'], 'required'],
            [['user_id', 'tour_id', 'rating'], 'integer'],
            [['comment'], 'string'],
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getTour()
    {
        return $this->hasOne(Tour::class, ['id' => 'tour_id']);
    }
}