<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Авторизация';
?>
<div class="auth-container">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-sign-in-alt"></i> <?= Html::encode($this->title) ?></h2>
        </div>
        <div class="card-body">
            <?php if (Yii::$app->session->hasFlash('success')): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?= Yii::$app->session->getFlash('success') ?>
                </div>
            <?php endif; ?>

            <?php if (Yii::$app->session->hasFlash('error')): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i> <?= Yii::$app->session->getFlash('error') ?>
                </div>
            <?php endif; ?>

            <form id="login-form" action="<?= Url::to(['auth/login']) ?>" method="post" autocomplete="off">
                <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                
                <div class="form-group">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" 
                           id="email" 
                           name="LoginForm[email]" 
                           class="form-control" 
                           required
                           placeholder="Введите ваш email"
                           autofocus>
                    <div class="invalid-feedback">Введите корректный email адрес</div>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">Пароль</label>
                    <input type="password" 
                           id="password" 
                           name="LoginForm[password]" 
                           class="form-control" 
                           required
                           placeholder="Введите ваш пароль">
                    <div class="invalid-feedback">Введите пароль</div>
                </div>

                <div class="form-group">
                    <div class="checkbox">
                        <input type="checkbox" 
                               id="rememberMe" 
                               name="LoginForm[rememberMe]" 
                               value="1"
                               checked>
                        <label for="rememberMe">Запомнить меня</label>
                    </div>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-block btn-lg">
                        <i class="fas fa-sign-in-alt"></i> Войти
                    </button>
                </div>

                <div class="text-center">
                    <p>Еще не зарегистрированы? <a href="<?= Url::to(['auth/register']) ?>">Регистрация</a></p>
                    <p><a href="<?= Url::to(['site/index']) ?>">Вернуться на главную</a></p>
                </div>
            </form>
        </div>
    </div>
    
    <div class="test-credentials">
        <h4><i class="fas fa-vial"></i> Тестовые учетные данные</h4>
        <p><strong>Администратор:</strong></p>
        <p>Email: <code>admintour@mail.ru</code></p>
        <p>Пароль: <code>admintour</code></p>
    </div>
</div>

<style>
.auth-container {
    max-width: 500px;
    margin: 40px auto;
    padding: 20px;
}

.card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    transition: transform 0.3s ease;
    animation: slideIn 0.5s ease;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(-30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.card:hover {
    transform: translateY(-5px);
}

.card-header {
    background: linear-gradient(45deg, #2c3e50, #34495e);
    color: white;
    padding: 20px;
}

.card-body {
    padding: 30px;
}

.test-credentials {
    background: linear-gradient(45deg, #f1c40f, #f39c12);
    color: #2c3e50;
    border-radius: 10px;
    padding: 20px;
    margin: 30px 0 20px;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.02); }
    100% { transform: scale(1); }
}

.test-credentials h4 {
    color: #2c3e50;
    margin-bottom: 15px;
}

.test-credentials code {
    background: rgba(255, 255, 255, 0.2);
    padding: 5px 10px;
    border-radius: 5px;
    font-weight: 600;
}

.form-group {
    margin-bottom: 25px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #2c3e50;
    font-size: 14px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 16px;
    transition: all 0.3s ease;
    background: #f8f9fa;
}

.form-control:focus {
    border-color: #3498db;
    background: white;
    box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
    outline: none;
}

.form-control.is-invalid {
    border-color: #e74c3c;
}

.invalid-feedback {
    display: none;
    color: #e74c3c;
    font-size: 14px;
    margin-top: 5px;
}

.form-control.is-invalid + .invalid-feedback {
    display: block;
}

.checkbox {
    display: flex;
    align-items: center;
    gap: 10px;
}

.checkbox input[type="checkbox"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
}

.checkbox label {
    cursor: pointer;
    margin-bottom: 0;
}

.btn-block {
    width: 100%;
}

.text-center {
    text-align: center;
}

.text-center a {
    color: #3498db;
    text-decoration: none;
}

.text-center a:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .auth-container {
        margin: 20px auto;
        padding: 10px;
    }
    
    .card-body {
        padding: 20px;
    }
}
</style>

<script>
// Валидация формы
function validateLoginForm() {
    let isValid = true;
    const form = document.getElementById('login-form');
    const inputs = form.querySelectorAll('input[required]');
    
    // Сброс предыдущих ошибок
    inputs.forEach(input => {
        input.classList.remove('is-invalid');
    });
    
    // Проверка email
    const email = document.getElementById('email');
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email.value)) {
        email.classList.add('is-invalid');
        isValid = false;
    }
    
    // Проверка обязательных полей
    inputs.forEach(input => {
        if (!input.value.trim()) {
            input.classList.add('is-invalid');
            isValid = false;
        }
    });
    
    if (!isValid) {
        // Прокрутка к первой ошибке
        const firstError = form.querySelector('.is-invalid');
        if (firstError) {
            firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
            firstError.focus();
        }
        
        // Анимация ошибки
        form.style.animation = 'none';
        setTimeout(() => {
            form.style.animation = 'shake 0.5s ease';
        }, 10);
    }
    
    return isValid;
}

// Инициализация при загрузке
document.addEventListener('DOMContentLoaded', function() {
    // Валидация при вводе
    const form = document.getElementById('login-form');
    if (form) {
        const inputs = form.querySelectorAll('input');
        inputs.forEach(input => {
            input.addEventListener('blur', function() {
                if (this.hasAttribute('required') && !this.value.trim()) {
                    this.classList.add('is-invalid');
                } else {
                    this.classList.remove('is-invalid');
                }
            });
            
            input.addEventListener('input', function() {
                this.classList.remove('is-invalid');
            });
        });
        
        // Обработка отправки формы
        form.addEventListener('submit', function(e) {
            if (!validateLoginForm()) {
                e.preventDefault();
            } else {
                // Показать загрузку
                const submitBtn = this.querySelector('button[type="submit"]');
                const originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Вход...';
                submitBtn.disabled = true;
                
                // Восстановить кнопку если форма не отправится
                setTimeout(() => {
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                }, 3000);
            }
        });
    }
    
    // Автофокус на поле email
    const emailInput = document.getElementById('email');
    if (emailInput) {
        setTimeout(() => {
            emailInput.focus();
        }, 100);
    }
});
</script>