<?php

use yii\helpers\Html;
use yii\bootstrap4\Nav;
use yii\bootstrap4\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?> | Туры выходного дня</title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="auth-wrapper">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <!-- Логотип и навигация -->
                <div class="text-center mb-4">
                    <?= Html::a(
                        '<i class="fas fa-mountain"></i> Туры выходного дня',
                        ['site/index'],
                        ['class' => 'h3 text-decoration-none text-dark font-weight-bold']
                    ) ?>
                </div>

                <?= $content ?>

                <!-- Ссылки для перехода -->
                <div class="text-center mt-4">
                    <?php if ($this->context->action->id === 'login'): ?>
                        <p class="mb-2">
                            Еще не зарегистрированы? 
                            <?= Html::a('Регистрация', ['auth/register'], [
                                'class' => 'font-weight-bold text-primary'
                            ]) ?>
                        </p>
                        <p class="mb-0">
                            <?= Html::a('Вернуться на главную', ['site/index'], [
                                'class' => 'text-muted small'
                            ]) ?>
                        </p>
                    <?php elseif ($this->context->action->id === 'register'): ?>
                        <p class="mb-2">
                            Уже зарегистрированы? 
                            <?= Html::a('Войти', ['auth/login'], [
                                'class' => 'font-weight-bold text-primary'
                            ]) ?>
                        </p>
                        <p class="mb-0">
                            <?= Html::a('Вернуться на главную', ['site/index'], [
                                'class' => 'text-muted small'
                            ]) ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>