<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Туры выходного дня - Главная';
// Убираем breadcrumbs для избежания ошибок
$this->params['breadcrumbs'] = [];
?>

<div class="card animate__animated animate__fadeIn">
    <div class="card-header">
        <h2><i class="fas fa-home"></i> Добро пожаловать в систему "Туры выходного дня"</h2>
    </div>
    
    <div class="card" style="margin-top: 20px;">
        <h3><i class="fas fa-rocket"></i> Быстрый старт</h3>
        
        <div class="row">
            <div class="col-md-6">
                <div style="padding: 20px; background: #f8f9fa; border-radius: 10px; height: 100%;">
                    <h4><i class="fas fa-sign-in-alt"></i> Тестирование авторизации</h4>
                    <p>Для тестирования системы используйте следующие учетные данные:</p>
                    
                    <div style="background: #fff; padding: 15px; border-radius: 8px; margin: 15px 0;">
                        <h5><i class="fas fa-user-tie"></i> Администратор</h5>
                        <p><strong>Email:</strong> <code>admintour@mail.ru</code></p>
                        <p><strong>Пароль:</strong> <code>admintour</code></p>
                        
                        <?= Html::a('<i class="fas fa-sign-in-alt"></i> Войти как администратор', 
                            ['/auth/login'], 
                            ['class' => 'btn btn-primary']
                        ) ?>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div style="padding: 20px; background: #f8f9fa; border-radius: 10px; height: 100%;">
                    <h4><i class="fas fa-user-plus"></i> Тестирование регистрации</h4>
                    <p>Создайте нового пользователя через форму регистрации:</p>
                    
                    <ul style="margin: 15px 0; padding-left: 20px;">
                        <li>ФИО - только кириллические буквы</li>
                        <li>Телефон: формат +7(XXX)XXX-XX-XX</li>
                        <li>Email - должен быть уникальным</li>
                        <li>Пароль - минимум 7 символов</li>
                    </ul>
                    
                    <?= Html::a('<i class="fas fa-user-plus"></i> Зарегистрироваться', 
                        ['/auth/register'], 
                        ['class' => 'btn btn-success']
                    ) ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card" style="margin-top: 20px;">
        <h3><i class="fas fa-info-circle"></i> Текущий статус</h3>
        
        <?php if (Yii::$app->user->isGuest): ?>
            <div style="text-align: center; padding: 40px 20px;">
                <i class="fas fa-user-slash" style="font-size: 4rem; color: #95a5a6; margin-bottom: 20px;"></i>
                <h4 style="color: #7f8c8d;">Вы не авторизованы в системе</h4>
                <p style="margin: 20px 0;">Для доступа ко всем возможностям портала, пожалуйста, авторизуйтесь или зарегистрируйтесь</p>
                
                <div style="display: flex; gap: 15px; justify-content: center; flex-wrap: wrap;">
                    <?= Html::a('<i class="fas fa-sign-in-alt"></i> Войти', ['/auth/login'], [
                        'class' => 'btn btn-primary btn-lg'
                    ]) ?>
                    
                    <?= Html::a('<i class="fas fa-user-plus"></i> Регистрация', ['/auth/register'], [
                        'class' => 'btn btn-success btn-lg'
                    ]) ?>
                </div>
            </div>
        <?php else: ?>
            <div class="user-info" style="margin: 20px 0;">
                <i class="fas fa-user-circle" style="font-size: 3rem;"></i>
                <div>
                    <h4><?= Html::encode(Yii::$app->user->identity->full_name) ?></h4>
                    <p><strong>Email:</strong> <?= Html::encode(Yii::$app->user->identity->email) ?></p>
                    <p>
                        <strong>Роль:</strong> 
                        <span class="role-badge <?= Yii::$app->user->identity->isAdmin() ? 'role-admin' : 'role-user' ?>">
                            <?= Yii::$app->user->identity->isAdmin() ? 'Администратор' : 'Пользователь' ?>
                        </span>
                    </p>
                </div>
            </div>
            
            <div style="display: flex; gap: 15px; flex-wrap: wrap;">
                <?= Html::a('<i class="fas fa-clipboard-list"></i> Мои заявки', '#', [
                    'class' => 'btn btn-primary'
                ]) ?>
                
                <?= Html::a('<i class="fas fa-plus-circle"></i> Новая заявка', '#', [
                    'class' => 'btn btn-success'
                ]) ?>
                
                <?php if (Yii::$app->user->identity->isAdmin()): ?>
                    <?= Html::a('<i class="fas fa-cogs"></i> Админ-панель', '#', [
                        'class' => 'btn btn-danger'
                    ]) ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="card" style="margin-top: 20px;">
        <h3><i class="fas fa-question-circle"></i> Частые вопросы</h3>
        
        <div style="margin-top: 20px;">
            <div style="margin-bottom: 15px; padding-bottom: 15px; border-bottom: 1px solid #eee;">
                <h5><i class="fas fa-question"></i> Какой формат телефона требуется при регистрации?</h5>
                <p>Требуется точный формат: <code>+7(XXX)XXX-XX-XX</code>. Например: <code>+7(999)123-45-67</code></p>
            </div>
            
            <div style="margin-bottom: 15px; padding-bottom: 15px; border-bottom: 1px solid #eee;">
                <h5><i class="fas fa-question"></i> Какие символы можно использовать в ФИО?</h5>
                <p>Только русские буквы и пробелы. Например: <code>Иванов Иван Иванович</code></p>
            </div>
            
            <div style="margin-bottom: 15px;">
                <h5><i class="fas fa-question"></i> Какой минимальный пароль?</h5>
                <p>Минимальная длина пароля - 7 символов. Рекомендуем использовать буквы, цифры и специальные символы.</p>
            </div>
        </div>
    </div>
</div>