<?php

use yii\helpers\Html;
use yii\helpers\Url;

/* @var $model \app\models\Tour */
?>

<div class="tour-card">
    <div class="tour-image">
        <?= Html::img($model->getImageUrl(), [
            'alt' => $model->name,
            'class' => 'img-fluid',
            'onerror' => "this.src='/images/tours/default.jpg'"
        ]) ?>
        <div class="tour-price">
            <?= $model->getFormattedPrice() ?>
        </div>
    </div>
    
    <div class="tour-content">
        <h3 class="tour-title"><?= Html::encode($model->name) ?></h3>
        
        <div class="tour-meta">
            <span class="tour-duration">
                <i class="fas fa-calendar-alt"></i> <?= $model->duration_days ?> дн.
            </span>
            <?php if ($model->max_participants): ?>
            <span class="tour-participants">
                <i class="fas fa-users"></i> до <?= $model->max_participants ?> чел.
            </span>
            <?php endif; ?>
        </div>
        
        <p class="tour-description">
            <?= Html::encode(mb_substr($model->short_description ?: $model->description, 0, 100)) ?>...
        </p>
        
        <div class="tour-actions">
            <?= Html::a('<i class="fas fa-eye"></i> Подробнее', 
                ['tour/view', 'id' => $model->id], 
                ['class' => 'btn btn-primary']
            ) ?>
            
            <?php if (!Yii::$app->user->isGuest): ?>
                <?= Html::a('<i class="fas fa-calendar-plus"></i> Бронь', 
                    ['application/create', 'tour_id' => $model->id], 
                    ['class' => 'btn btn-success']
                ) ?>
            <?php else: ?>
                <?= Html::a('<i class="fas fa-calendar-plus"></i> Бронь', 
                    ['auth/login'], 
                    ['class' => 'btn btn-success']
                ) ?>
            <?php endif; ?>
        </div>
    </div>
</div>