<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $tour->name;
?>
<div class="tour-view">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-info-circle"></i> <?= Html::encode($tour->name) ?></h2>
        </div>
        
        <div class="card-body">
            <div class="tour-details">
                <div class="tour-image-large">
                    <?= Html::img('/images/tours/default.jpg', [
                        'alt' => $tour->name,
                        'class' => 'img-fluid'
                    ]) ?>
                </div>
                
                <div class="tour-info-large">
                    <div class="tour-price-large">
                        <h3><?= number_format($tour->price, 0, ',', ' ') ?> ₽</h3>
                        <p>за человека</p>
                    </div>
                    
                    <div class="tour-specs">
                        <p><i class="fas fa-calendar"></i> <strong>Длительность:</strong> <?= $tour->duration_days ?> дня</p>
                        <p><i class="fas fa-users"></i> <strong>Участников:</strong> до <?= $tour->max_participants ?> человек</p>
                        <p><i class="fas fa-map-marker-alt"></i> <strong>Локация:</strong> Уральский регион</p>
                    </div>
                    
                    <?php if (!Yii::$app->user->isGuest): ?>
                        <?= Html::a('Забронировать тур', ['application/create', 'tour_id' => $tour->id], [
                            'class' => 'btn btn-success btn-lg btn-block'
                        ]) ?>
                    <?php else: ?>
                        <?= Html::a('Забронировать тур', ['auth/login'], [
                            'class' => 'btn btn-success btn-lg btn-block'
                        ]) ?>
                        <p class="text-center mt-2">
                            <small>Для бронирования необходимо войти в систему</small>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="tour-description-full mt-4">
                <h3><i class="fas fa-file-alt"></i> Описание тура</h3>
                <div class="description-text">
                    <?= nl2br(Html::encode($tour->description)) ?>
                </div>
            </div>
            
            <?php if ($tour->program): ?>
            <div class="tour-program mt-4">
                <h3><i class="fas fa-list-ol"></i> Программа</h3>
                <div class="program-text">
                    <?= nl2br(Html::encode($tour->program)) ?>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="tour-actions mt-4">
                <?= Html::a('Вернуться к каталогу', ['tour/index'], [
                    'class' => 'btn btn-outline'
                ]) ?>
            </div>
        </div>
    </div>
</div>

<style>
.tour-view {
    padding: 20px 0;
}

.tour-details {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
    margin-bottom: 30px;
}

.tour-image-large img {
    width: 100%;
    height: 300px;
    object-fit: cover;
    border-radius: 8px;
}

.tour-info-large {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.tour-price-large {
    background: #2c3e50;
    color: white;
    padding: 20px;
    border-radius: 8px;
    text-align: center;
}

.tour-price-large h3 {
    font-size: 32px;
    margin: 0;
}

.tour-price-large p {
    margin: 5px 0 0;
    opacity: 0.8;
}

.tour-specs {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
}

.tour-specs p {
    margin-bottom: 10px;
    font-size: 16px;
}

.tour-specs i {
    width: 25px;
    color: #3498db;
}

.tour-description-full h3,
.tour-program h3 {
    color: #2c3e50;
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 2px solid #3498db;
}

.description-text,
.program-text {
    line-height: 1.8;
    font-size: 16px;
    white-space: pre-line;
}

.tour-actions {
    text-align: center;
}

.btn-block {
    width: 100%;
}

@media (max-width: 768px) {
    .tour-details {
        grid-template-columns: 1fr;
    }
    
    .tour-image-large img {
        height: 250px;
    }
}
</style>